function [H_sep,G_sep,M_sep,L_sep] = Separated_observer(A,F,D1,C,D2)

[n,q] = size(F);
[p,q1] = size(D2);

% Augmented system
bar_A = [A F zeros(n,q1); zeros(q+q1,q+n+q1)]; 
bar_C = [C zeros(p,q) D2]; 
Cex = eye(n);
Cefa = [1;1];
Cefs = [1;1];

gamma = 0.2;

% solve LMI using Matlab LMI toolbox
setlmis([]);

Q = lmivar(1,[n,1]); 
R = lmivar(1,[q,1]); 
R1 = lmivar(1,[q1,0]); 
M2 = lmivar(2,[n,p]); 
M3 = lmivar(2,[n,p]); 
M4 = lmivar(2,[q,p]); 
M5 = lmivar(2,[q,p]); 
M6 = lmivar(2,[q1,p]); 
M7 = lmivar(2,[q1,p]); 

% lmi 1
lmiterm([-1 1 1 Q], 1, 1);
lmiterm([1 1 1 0], 0);

% lmi 2
lmiterm([-2 1 1 R], 1, 1);
lmiterm([2 1 1 0], 0);

% lmi 3
lmiterm([-3 1 1 R1], 1, 1);
lmiterm([3 1 1 0], 0);

% lmi 4
lmiterm([4 1 1 Q], 1, A, 's');
lmiterm([4 1 1 M2], -1, C*A, 's');
lmiterm([4 1 1 M3], -1, C, 's');
lmiterm([4 1 2 Q], 1, F);
lmiterm([4 1 2 M2], -1, C*F);

lmiterm([4 1 3 Q], 1, D1);
lmiterm([4 1 3 M3], 1, D2);

lmiterm([4 1 4 Q], 1, D1);
lmiterm([4 1 4 M2], -1, C*D1);

lmiterm([4 1 6 M2], -1, D2);
lmiterm([4 1 7 0], Cex');

lmiterm([4 2 1 M4], -1, C*A);
lmiterm([4 2 1 M5], -1, C);

lmiterm([4 2 2 M4], -1, C*F, 's');
lmiterm([4 2 3 M5], -1, D2);
lmiterm([4 2 4 M4], -1, C*D1); 
lmiterm([4 2 5 R], 1, 1);
lmiterm([4 2 6 M4], -1, D2);
lmiterm([4 2 7 0], Cefa');

lmiterm([4 3 1 M6], -1, C*A);
lmiterm([4 3 1 M7], -1, C);

lmiterm([4 3 2 M6], -1, C*F);

lmiterm([4 3 3 M7], -1, D2);
lmiterm([4 3 4 M6], -1, C*D1);
lmiterm([4 3 6 R1], 1, 1);
lmiterm([4 3 6 M6], -1, D2);
lmiterm([4 3 7 0], Cefs');

lmiterm([4 4 4 0], -1);
lmiterm([4 5 5 0], -1);

lmiterm([4 6 6 0], -gamma);
lmiterm([4 7 7 0], -gamma);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
lmis = getlmis;

[tmin, xfeasp] = feasp(lmis);
Q = dec2mat(lmis,  xfeasp, Q);
R = dec2mat(lmis,  xfeasp, R);
R1 = dec2mat(lmis,  xfeasp, R1);
M2 = dec2mat(lmis,  xfeasp, M2);
M3 = dec2mat(lmis,  xfeasp, M3);
M4 = dec2mat(lmis,  xfeasp, M4);
M5 = dec2mat(lmis,  xfeasp, M5);
M6 = dec2mat(lmis,  xfeasp, M6);
M7 = dec2mat(lmis,  xfeasp, M7);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5

H1 = inv(Q)*M2;
H2 = inv(R)*M4;
H3 = inv(R1)*M6;
L11 = inv(Q)*M3;
L12 = inv(R)*M5;
L13 = inv(R1)*M7;

H_sep = [H1;H2;H3];
L1 = [L11;L12;L13];
G_sep = eye(4) - H_sep*bar_C;
M_sep = G_sep*bar_A - L1*bar_C;
L2 = M_sep*H_sep;
L_sep = L1 + L2;
